/************************************************************************\
\************************************************************************/


//#include "objects.h"
//#include "NewtonScript.h"
//#include "applefile.h"

typedef unsigned long	ULong;
typedef unsigned char	UByte;


typedef struct ParseInfo {
	OSType		fType;
	OSType		fCreator;
	ULong		dataLen;
	char		fName[64];
} ParseInfo;

char	*result;

static long _parseApplefile ( void * srcBinP, void * destBinP, ParseInfo *rslt );
void TestApplefile (  );

void TestApplefile (  )
{
	Handle	applefileH = GetResource ( 'bind', 1001 );	// Unicode base64 = 1002

	ParseInfo	parseInfo;

	DetachResource ( applefileH );
	HLock ( applefileH );

	result = NewPtrClear ( GetHandleSize(applefileH) * 2 );

	void	* srcP  = (void *)*applefileH;
	void	* destBinP = result;

	long resultLength = _parseApplefile ( srcP, destBinP, &parseInfo );

	if ( resultLength == -1 )
	{
	//	SetVariable ( infoFrame, kindSymbol, SYM ( unknown ) );

		parseInfo.dataLen = 0;		// tell caller to set length to 0!!!
	}

	else
	{
		switch ( parseInfo.fType )
		{
		case 'pkg ':
		//	SetVariable ( infoFrame, kindSymbol, SYM ( package ) );
			SysBeep(12);
			break;

		case 'newt':
			if ( parseInfo.fCreator == 'rot' )
				SysBeep(12);
			//	SetVariable ( infoFrame, kindSymbol, SYM ( enRouteFrame ) );
			break;

		case 'TEXT':
			SysBeep(12);
		//	SetVariable ( infoFrame, kindSymbol, SYM ( textFile ) );
			break;
		}

		UByte	*cP;
		UniChar	uFType[5];
		UniChar	uFCrea[5];

		cP = (UByte *)&parseInfo.fType;
		for ( short i = 0; i < 4; i++ )
		{
			uFType[i] = cP[i];
		}
		uFType[4] = 0;
	//	SetVariable ( infoFrame, SYM ( fType ), MakeString ( uFType ) );

		cP = (UByte *)&parseInfo.fCreator;
		for ( short i = 0; i < 4; i++ )
		{
			uFCrea[i] = cP[i];
		}
		uFCrea[4] = 0;
	//	SetVariable ( infoFrame, SYM ( fCreator ), MakeString ( uFCrea ) );

	//	SetVariable ( infoFrame, SYM ( fName ), MakeString ( parseInfo.fName ) );
	}

//	return MakeInt ( parseInfo.dataLen );

}

typedef struct AF_Entry // an Applefile entry descriptor
{
	ULong	entryID; 	// entry type: see list, 0 invalid
	ULong	entryOffset; // offset from beginning of file to entry's data
	ULong	entryLength; // length of data in octets
} AF_Entry;

static long _parseApplefile ( void * srcBinP, void * destBinP, ParseInfo *rslt )
{
	ULong		* lP = (ULong *)srcBinP;
	short		* sP;
	void 		* eDataP;
	AF_Entry	* entryP;

	void	* dataStart;
	long	dataLen = -1;
	OSType	typ     = 0x3F3F3F3F;	// '????';
	OSType	crea    = 0x3F3F3F3F;	// '????';

	if ( ( *lP == 0x00051600 ) || ( *lP == 0x0051607 ) )	// AppleSingle or AppleDouble
	{
		sP     = (short *)srcBinP;
		entryP = (AF_Entry *)&sP[13];
		short		numEntries = sP[12];

		for ( short i = 0; i < numEntries; i++, entryP++ )
		{
			eDataP = (void *)( (ULong)srcBinP + entryP->entryOffset );
			ULong	sz = entryP->entryLength;
			switch ( entryP->entryID )
			{
			case 1:						// AS_DATA
				dataStart = eDataP;
				dataLen = (long)sz;
				break;
			case 3:						// AS_REALNAME
				if ( sz > 63 ) sz = 63;
				BlockMove ( eDataP, rslt->fName, sz );
				rslt->fName[sz] = 0;
				break;
			case 9:						// AS_FINDERINFO
				OSType	* oP = (OSType *)eDataP;
				typ  = oP[0];
				crea = oP[1];
				break;
			}
		}

		rslt->fType    = typ;
		rslt->fCreator = crea;

		if ( (typ == 'pkg ')
		||   (typ == 'newt' && crea == 'rot')
		||   (typ == 'TEXT') )
		{
			if ( dataLen > 0 )
			{
				BlockMove ( dataStart, destBinP, dataLen );
			}
			if ( typ == 'TEXT' )
			{
				char	* txtP = (char *)dataStart;
				txtP[dataLen] = 0;
				dataLen++;
			}
			rslt->dataLen  = dataLen;
		}
	}

	return dataLen;
}
/************************************************************
	char	fileName[64] = "Some kind of file is here";

	rslt->fType = 'pkg ';
	rslt->fCreator = 'pkgX';
	rslt->dataLen = 17;

	BlockMove ( fileName, rslt->fName, 64 );

	dataLen = rslt->dataLen;

	return dataLen;
}

/*
void BlockMove ( const void * srcPtr, void * destPtr, Size byteCount );
void			DisposPtr(Ptr p);
Size			GetPtrSize(Ptr p);
Ptr				NewPtr(Size size);
Ptr				NewPtrClear(Size byteCount);
Heap			PtrToHeap(Ptr);
Ptr				ReallocPtr(Ptr, Size);			// like realloc


Size			TotalFreeInHeap(Heap DEFAULT_NIL);
Size			LargestFreeInHeap(Heap DEFAULT_NIL);
unsigned long	CountFreeBlocks(Heap DEFAULT_NIL);
Size			TotalUsedInHeap(Heap DEFAULT_NIL);
Size			MaxHeapSize(Heap DEFAULT_NIL);

//____________________________________________________________________
// Frame & Slot Functions

extern	Ref		AllocateFrame(void);
extern	Boolean	FrameHasPath(RefArg obj, RefArg thePath);
extern	Boolean	FrameHasSlot(RefArg obj, RefArg slot);
extern	Ref		GetFramePath(RefArg obj, RefArg thePath);
extern	Ref		GetFrameSlot(RefArg obj, RefArg slot);
extern	long	Length ( RefArg obj );		// Length in bytes or slots
extern	void	MapSlots(RefArg obj, MapSlotsFunction func, ULong anything);

extern	void	RemoveSlot(RefArg frame, RefArg tag);
extern	void	SetFramePath(RefArg obj, RefArg thePath, RefArg value);		
extern	void	SetFrameSlot(RefArg obj, RefArg slot, RefArg value);
extern	void	SetLength(RefArg obj, long length);

extern	Ref		MakeString(const char* str);

*/
